/*****************************************************************************
 * ugBASIC - an isomorphic BASIC language compiler for retrocomputers        *
 *****************************************************************************
 * Copyright 2021-2022 Marco Spedaletti (asimov@mclink.it)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *----------------------------------------------------------------------------
 * Concesso in licenza secondo i termini della Licenza Apache, versione 2.0
 * (la "Licenza"); è proibito usare questo file se non in conformità alla
 * Licenza. Una copia della Licenza è disponibile all'indirizzo:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Se non richiesto dalla legislazione vigente o concordato per iscritto,
 * il software distribuito nei termini della Licenza è distribuito
 * "COSÌ COM'È", SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO, esplicite o
 * implicite. Consultare la Licenza per il testo specifico che regola le
 * autorizzazioni e le limitazioni previste dalla medesima.
 ****************************************************************************/

/****************************************************************************
 * INCLUDE SECTION 
 ****************************************************************************/

#include "../../ugbc.h"

/****************************************************************************
 * CODE SECTION 
 ****************************************************************************/

/* <usermanual>
@keyword TIMER

@target atari
</usermanual> */

Variable * get_timer( Environment * _environment ) {

    Variable * result = variable_temporary( _environment, VT_WORD, "(result of get timer)");

    char resultAddress[MAX_TEMPORARY_STORAGE]; 
    cpu_move_8bit( _environment, "$14", result->realName );
    sprintf(resultAddress, "%s+1", result->realName );
    cpu_move_8bit( _environment, "$13", resultAddress );
    // sprintf(resultAddress, "%s+2", result->realName );
    // cpu_move_8bit( _environment, "$12", resultAddress );
    
    return result;
    
}

/* <usermanual>
@keyword TIMER

@target atari
</usermanual> */
void set_timer( Environment * _environment, char * _value ) {

    Variable * value = variable_retrieve_or_define( _environment, _value, VT_WORD, 0 );

    char valueAddress[MAX_TEMPORARY_STORAGE]; 
    cpu_move_8bit( _environment, value->realName, "$14" );
    sprintf(valueAddress, "%s+1", value->realName );
    cpu_move_8bit( _environment, valueAddress, "$13" );
    cpu_move_8bit( _environment, "#0", "$12" );
    
}